/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	HotSpot
**
** DESCRIPTION:	Dispatches behaviours when a sprite is dropped in a hotspot
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef HOTSPOT_H
#define HOTSPOT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ContentMap.h"
#include "../Game/Isola.h"	//EDirection
#include "../Villagers/Villager.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int HotSpot_c_iMaxHotSpots = CContentMap::eHotSpot_NumberOf;

/******************************************************************************\
** TYPE DEFINITIONS
\******************************************************************************/
typedef const bool (* LPHOTSPOTHANDLER)(CVillager &Villager);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CHotSpot
{
private:

	//class structures
	struct SHotSpot
	{
		LPHOTSPOTHANDLER	m_pHandler;
		EDirection			m_eBias;
	};

	//class data
	SHotSpot	m_sHotSpot[HotSpot_c_iMaxHotSpots];

	//class methods
	//setup
	public:		CHotSpot(void);

	// process
	public:		const bool Dispatch(CVillager &Villager, const CContentMap::EHotSpot eHotSpot) const;

	private:	static const bool Kindling(CVillager &Villager);
	private:	static const bool Firewood(CVillager &Villager);
	private:	static const bool FirePlace(CVillager &Villager);
	private:	static const bool BathHotspot(CVillager &Villager);
	private:	static const bool BrokenLift(CVillager &Villager);
	private:	static const bool LiftPlatform(CVillager &Villager);
	private:	static const bool AlchemyTableHandler(CVillager &Villager);
	private:	static const bool AlchemyPotHotSpot(CVillager &Villager);
	private:	static const bool Herb1(CVillager &Villager);
	private:	static const bool Herb2(CVillager &Villager);
	private:	static const bool Herb3(CVillager &Villager);
	private:	static const bool Herb4(CVillager &Villager);
	private:	static const bool Herb5(CVillager &Villager);
	private:	static const bool Herb6(CVillager &Villager);
	private:	static const bool Herb7(CVillager &Villager);
	private:	static const bool Ampitheatre(CVillager &Villager);
	private:	static const bool Foodbin(CVillager &Villager);
	private:	static const bool BrokenStatue(CVillager &Villager);
	private:	static const bool StatuePath(CVillager &Villager);
	private:	static const bool BeehiveHotspot(CVillager &Villager);
	private:	static const bool House1(CVillager &Villager);
	private:	static const bool House2(CVillager &Villager);
	private:	static const bool House3(CVillager &Villager);
	private:	static const bool Hospital(CVillager &Villager);
	private:	static const bool ClothingHut(CVillager &Villager);
	private:	static const bool ResearchHotspot(CVillager &Villager);
	private:	static const bool FruitTree(CVillager &Villager);
	private:	static const bool SunDiskHotSpot(CVillager &Villager);
	private:	static const bool RuinsHotSpot(CVillager &Villager);
	private:	static const bool KeyJump(CVillager &Villager);
	private:	static const bool DivingPlatform(CVillager &Villager);
	private:	static const bool ChalkBoardHandler(CVillager &Villager);
	private:	static const bool RosterOfTheDeadHandler(CVillager &Villager);
	private:	static const bool BurnedTorch(CVillager &Villager);
	private:	static const bool PathTop(CVillager &Villager);
	private:	static const bool Spring(CVillager &Villager);
	private:	static const bool HospitalLab(CVillager &Villager);
	private:	static const bool Clifftree(CVillager &Villager);

	// access
	public:		void SetHandler(const CContentMap::EHotSpot eHotSpot, LPHOTSPOTHANDLER pHandler, const EDirection eBias = eDirection_None);
	public:		const EDirection Bias(const CContentMap::EHotSpot eHotSpot);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CHotSpot		HotSpot;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/